#ifndef MATERIALMANAGER_H_
#define MATERIALMANAGER_H_

#include <sstream>
#include <list>
#include <multimap.h>
#include "../DataTypes/DataInteraction.h"
#include "../DataTypes/DataMaterial.h"
#include "../Configuration/ConfigurationServer.h"
using namespace std;
using namespace DataTypes;
using namespace Configuration;
namespace PhysicsEngine
{

class MaterialManager
{
public:
	static MaterialManager *GetInstance();
	void RegisterMaterial(DataMaterial data);
	DataMaterial* GetDataMaterial(int id);
	void RegisterInteraction(int idmaterial1, int idmaterial2, DataInteraction data);
	DataInteraction GetDataInteraction(int idmaterial1, int idmaterial2);
protected:
	MaterialManager();
private:
	static MaterialManager *instance;
	list <DataMaterial> materials;
	map<string,DataInteraction> interactions;
};

}

#endif /*MATERIALMANAGER_H_*/
